#version 330
#extension GL_EXT_gpu_shader4 : enable
//Circular Multiplication GraphMod01.fsh  by n1kk
//https://www.shadertoy.com/view/4lyXz3
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

#define iMouse AUTO_MOUSE
#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
#define MOUSE_PRESS vec2(0.0,0.0)
#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
#define RIGID_SCROLL
// alternatively use static mouse definition
//#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

#define PI 3.14159265359
#define LINE_COUNT 400.
//#define ANIMATE_HALF_FILL true

float getLineThickness(float thickness) {
    // thickness optimized for resolution
    return thickness * 400. / max(iResolution.x, iResolution.y); 
}

//------- CIRCLE

float circle(vec2 origin, vec2 pos, float radius, float thickness)
{
    float n = 100.0 / getLineThickness(thickness);
    return clamp(((1.0-abs(length(origin + pos)-radius))-(1.0 - 1.0/n)) * n, 0.0, 1.0);
}

float circle(vec2 origin, vec2 pos, float radius)
{
    return circle(origin, pos, radius, 1.0);
}

float circleFill(vec2 origin, vec2 pos, float radius)
{
    return clamp(((1.0-(length(origin+pos)-radius))-0.99)*100.0, 0.0, 1.0);   
}

float circleGlow(vec2 origin, vec2 pos, float radius, float len, float str)
{
    float inCircle = ((1.0-(length(origin + pos)-(radius + len)))-0.99) * str;
    return clamp(inCircle, 0.0, 1.0);   
}

float circleLineGlow(vec2 origin, vec2 pos, float radius, float len, float str)
{
    float inCircle = ((1.0-abs(length(origin + pos)-(radius)) + len)-0.99) * str;
    return clamp(inCircle, 0.0, 1.0);   
}

// ------ LINE 

float line(in vec2 p, in vec2 a, in vec2 b, float thickness)
{
    vec2 pa = -p - a;
    vec2 ba = b - a;
    float h = clamp( dot(pa,ba)/dot(ba,ba), 0.0, 1.0 );
    float d = length( pa - ba*h );
    //return clamp(((1.0 - d)-0.99)* 100.0 , 0.0, 1.0);
	//float n = 100.0 / thickness;
    float n = 100.0 / getLineThickness(thickness);
    return clamp(((1.0 - d) - (1.0 - 1.0/n)) * n , 0.0, 1.0);
}

float line( in vec2 p, in vec2 a, in vec2 b )
{
	return line(p, a, b, 1.0);
}

float lineGlow(in vec2 p, in vec2 a, in vec2 b, float str )
{
    vec2 pa = -p - a;
    vec2 ba = b - a;
    float h = clamp( dot(pa,ba)/dot(ba,ba), 0.0, 1.0 );
    float d = length( pa - ba*h );
    float n = 10.0;
    return 0.1 * str * clamp(((1.0 - d) - (1.0 - 1.0/n)) * n , 0.0, 1.0);
}

// ------- GEOM

vec2 pointOnACircle(vec2 pos, float r, float a) {
 	return vec2(pos.x + r * sin(a),  pos.y + r * cos(a));
}

// ------ GRAPH

float multCircle(vec2 origin, vec2 pos, float radius, float multiplier, 
           float cglow, float cglows, float lglow,
           bool ccw, float angle_shift) {
    float c = .0;
    
    c += circle(origin, pos, radius, 1.0);
    c += circleLineGlow(origin, pos, radius, cglow, cglows);
    
    for (float i = 0.0; i <= LINE_COUNT; i++) {
#ifdef ANIMATE_HALF_FILL
        if (i > LINE_COUNT * 
            (.5 + .5 * smoothstep(-1., 1., sin(iTime*.5)))) break;
#endif                
        float rotation_dir = ccw ? -1. : 1.;
        float angle1 = i * (2.*PI/LINE_COUNT);
        float angle2 = multiplier * i * (2.*PI/LINE_COUNT);
        
        vec2 pos1 = pointOnACircle(pos, radius, angle_shift + angle1 * rotation_dir);
        vec2 pos2 = pointOnACircle(pos, radius, angle_shift + angle2 * rotation_dir);
        
        c += line(origin, pos1, pos2, 0.8) * 0.5;
        c += lineGlow(origin, pos1, pos2, lglow) * 0.5;
    }
    
    return c;
}

/// =============== MAIN ===================
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
	vec2 uv = gl_FragCoord.xy / iResolution.xy;
    // origin
    vec2 p = -1.0 + 2.0 * uv;
    p.x *= iResolution.x / iResolution.y;
    
    float t = iTime * 0.5;
    
    #define c(t, s) 0.5 + 0.25 * sin(t+s)
    
    vec3 colour1 = vec3(c(t,2.96), c(t,54.88), c(t,48.11));
	vec3 colour2 = vec3(c(t,12.51), c(t,2.58), c(t,71.99));
    
    vec3 c = vec3(0);
    
    bool clicked = iMouse.z > 0. || iMouse.w > 0.;
    
    #define C_RAD 0.9
    #define C_POS vec2(0)
    // 8.69 10.091 11.0 12.11 13.5 15.285 17.666 19.182
    #define START_FRAME 102.5
    
    float speed = (clicked ? 0.1 : 0.5);
    speed *= (0.4 + 0.15 * sin (iTime*0.1));
    float M = START_FRAME + iTime * speed;
    
    float inCircle = circleFill(p, C_POS, C_RAD);
    if (inCircle > .0) {
   		c += multCircle(p, C_POS, C_RAD, M, 
                        0.1, 0.5, 0.4,
                       true, iTime*.05);
        c *= colour1;
    } else {
    	c += multCircle(p, C_POS, 2.0, START_FRAME + M * 0.05, 
                        0.1, 1.0, 0.9,
                       false, -iTime*.01);
    	c *= colour2;
    }
    
    c = clamp(c, 0.0, 1.0);
    gl_FragColor = vec4(c, 1.0);
}
